<?php
//coded for PHP 5
/**
  * This class will define an object very similar to the Popmonger object returned by PopMonger 3 itself. This class
  * can be used for debugging purposes by modifying the fields near the top of the class. To use this class, 
  * either paste the following code into your script, or download the <a href="PopmongerClass.zip" alt="PopmongerClass zipfile">PopmongerClass.php file</a>,
  * unzip it into the same directory as your Popmonger 3 script, and add the text  require('PopmongerClass.php'); 
  * to the top of your current PHP script.  If you are not running the script via apache or another web server, you may run
  * the script with the php.exe Command-Line interpreter.
 */</p>
 

class Popmonger {
  
  public $fields, $headers, $headerText, $bodyText, $messageText, $failedAddress, $mimeParts;
  
  public function  __construct() {
   
    /**
    * Fields that would be returned by Popmonger 3 if the "Parse feedback using delimiters" box is checked in
    * the Actions tab of the Task options.
    */
    $this->fields = array( "Robert" , "Smith" , "bobsmith@university.edu" , "Oct" , "22" , "2006" );
   
    /**
    * Headers that Popmonger 3 would return for this email. Note that this is an associative array, as is the
    * array returned by Popmonger 3.
    */
    $this->headers = array( "subject" => "subject" , "from" => "from" , "to" => "to" );
   
    /**
    * The raw header text for this email.
    */
    $this->headerText = "Subject: ".$this->headers['subject']."\r\nFrom: ".$this->headers['from']."\r\nTo: 
    ".$this->headers['to'];
   
    /**
    * The raw body text for this email.
    */
    $this->bodyText = "This is the body which includes both HTML and TEXT portions if both were sent.";
   
    /**
    * The raw message text for this email.
    */
    $this->messageText = "This is the raw message text which includes the ENTIRE MESSAGE, headers and all.";
   
    /**
    * The original sender address for created a bounced/failure address list.
    */
    $this->failedAddress = "failedaddress@bounced.com";
 
    /**
    * The MIME parts of this email, which would normally include any files attached. Feel free to use readfile()
    * here if you actually need to return a file for debugging purposes.
    */
    $this->mimeParts = array( "file 1" , "file 2" , "file 3" );
  
  }
  
  
  /**
  * This function will return the number of fields that have been successfully parsed by Popmonger 3 (in
  * this case, a count of the number of fields in the fields var array.
  *
  * @return - integer Number of fields parsed out of this email
  */
  
  function FieldsCount() {
  return count( $this->fields );
  }
  
  /**
  * This function will return the number of MIME parts in this email (in this case, a count of the number of
  * fields in the mimeParts var array.
  *
  * @return - integer Number of MIME parts in this email
  */
  
  function MIMEPartsCount() {
  return count( $this->$mimeParts );
  }
  
  /**
  * This function will return the message text associated with this email.
  *
  * @return - String message text
  */
  
  function MessageText() {
  return $this->$messageText;
  }

  /**
  * This function will return the failed sender address associated with a bounced email.
  *
  * @return - String message text
  */
   
  function FailedAddress() {
  return $this->$failedAddress;
  }
  
   
  /**
  * This function will return the header text associated with this email.
  *
  * @return - String header text
  */
  
  function HeaderText() {
  return $this->$headerText;
  }
  
  /**
  * This function will return the body text associated with this email.
  *
  * @return - String body text
  */
  
  function BodyText() {
  return $this->$bodyText;
  }
  
  /**
  * This function will return the i-th field associated with the email, based on the text that Popmonger 3
  * parsed out. Note that this function does not perform any bounds-checking! Use the FieldsCount() function to
  * ensure that the index is within bounds.
  *
  * @param int - Field index to retrieve
  *
  * @return - String field value
  */
  
  function Field( $i ) {
  return $this->fields[$i];
  }
  
  /**
  * Send an email to this recipient. Note that this function does NOT actually send an email! It is only here
  * for debugging purposes.
  *
  * @param String - From: email address
  * @param String - To: email address
  * @param String - Subject of the email
  * @param String - Body of the email
  * @param String - Headers for this email
  */
  
  function SendMail( $from , $to , $subject , $body , $headers ) {
  echo "Would have sent email to ".$to." from ".$from." with subject ".$subject."\r\n";
  }
  
  /**
  * Redirect this message to another email address. Note that this function does NOT send email, it is only
  * here for debugging purposes.
  *
  * @param String - Email address to redirect this message to
  */
  
  function RedirectMessage( $email ) {
  echo "redirecting this message to ".$email."r\n";
  }
  
  /**
  * Reply to this message with this text. Note that thie function does NOT send email, it is only here for
  * debugging purposes.
  *
  * @param String - From: email address
  * @param String - Subject of the email
  * @param String - Text to reply with
  */
  
  function ReplyWithText( $from , $subject , $replyText ) {
  echo "replying to ".$from." with subject ".$subject." and text ".$replyText."\r\n";
  }
  
  /**
  * Save text to a file.
  *
  * @param String - Filename to write to
  * @param String - Text to write to this file
  * @param boolean - TRUE to append to a file, FALSE to truncate the file to 0 length and then write
  */
  
  function SaveToFile( $filename , $text , $append ) {
  $write = 'w';
  if( $append == TRUE || $append == '1' ) {
  $write = 'a';
  }
  $fp = fopen( $filename , $write );
  fputs( $fp , $text );
  fclose( $fp );
  }
  
  /**
  * Returns this header field. This would usually refer to the header fields parsed out by PopMonger, but
  * for debugging purposes returns the value of this element in the headers var array.
  *
  * @param String - Name of the header field to retrieve
  *
  * @return String - Value of this header field
  */
  
  function HeaderField( $name ) {
  return $this->headers[$name];
  }
  
  /**
  * Returns this MIME part of the email. This would usually refer to the MIME parts of the email, but for
  * debugging purposes returns the value of the mimeParts var array.
  *
  * @param integer - Index of the element to retrieve
  *
  * @return String - Value of this MIME part of the email
  */
  
  function MIMEPart( $index ) {
  return $this->mimeParts[$index];
  }

}

// End of Popmonger Class declaration

//Instantiate a new popmonger object with the same name as the object returned by PopMonger itself.
//$popmonger = new Popmonger();

//Confirmation that a PopMonger object was created.
//echo "Made a new popmonger!";

?>
